<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{{ config('app.name') }}</title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link rel="stylesheet" href="{{ asset('css/style.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/animations.css') }}">
    <link rel="stylesheet" href="{{ asset('css/simple-notify.min.css') }}" />
    <link href='https://fonts.googleapis.com/css?family=Varela+Round' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.13/css/all.css" crossorigin="anonymous">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js" type="text/javascript"></script>
    <script src="{{ asset('js/simple-notify.min.js') }}"></script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>

    <style>
    body {
        font-family: 'Nunito', sans-serif;
    }
    </style>
</head>

<body class="">
    <div class="container-fluid header">
        <div class="container">
            <img src="{{ asset('img/logo.png') }}" height="50" width="auto" alt="Logo" class="logo mt-0">
            <ul class="desktop-menu d-none d-lg-inline-block">
                <li><a href="{{ route('welcome') }}">Home</a></li>
                <li><a href="{{ route('login') }}">Faucet</a></li>
                <li><a href="{{ route('login') }}">Shortlinks</a></li>
                <li><a href="{{ route('login') }}">Staking</a></li>
            </ul>
            <div class="navbar">
                <a href="{{ route('login') }}" class="login">
                    <p>SIGN IN</p>
                </a>
                <a href="{{ route('register') }}" class="register">
                    <p>SIGN UP</p>
                </a>
            </div>
        </div>
    </div>
    <div class="container text-center"><br><br>
        <h1 class="text-center expandOpen" style="font-size: 32px;"><strong>Terms &amp; Conditions</strong></h1><br><br>
        <p class="desc on-gray text-left">
            <strong>1. Terms</strong><br><br>
            This agreement is a legally binding document relating to the use of the {{ url('/') }} website and is
            an agreement that the parties must abide by. By using this website, you are deemed to have read these terms
            and conditions and you agree to be bound by all applicable laws and regulations and to be responsible for
            compliance with all applicable local laws. <br><br>
            The user agrees in advance that {{ config('app.name') }} can make any changes to these terms if necessary. Any changes or
            updates that may be made by us when necessary will be posted on this page as well as on our social media
            accounts (Facebook/Twitter). If you continue to use this site and our services after such changes, it is
            deemed that you agree to the changed terms. Please check the latest information posted here and on our
            social accounts to be informed of the changes. <br><br>
            {{ config('app.name') }} assumes no responsibility for any damages caused by technical problems or any changes in crypto
            coins or 3rd party practices or finalization of website services or periodic maintenance work, any server
            errors, updates, etc.<br><br>
            If you do not agree to any of these terms, your use of or access to this site is prohibited. The materials
            on this website are protected by applicable copyright and trademark law.<br><br>
            <strong>2. Use License</strong><br><br>
            <strong>2.1. Copyrights</strong><br><br>
            Permission is granted to download a copy of the materials (information or software) on the {{ config('app.name') }} website
            only for personal, non-commercial temporary viewing.<br><br>
            This is not a transfer of license and you cannot do the following under this license:<br><br>
            ⦁ using, transferring, copying, distributing or modifying all or part of {{ config('app.name') }}'s images and other
            content obtained from this website,<br><br>
            ⦁ Use of the Site content for any commercial purpose or use in public areas . (both commercial and
            non-commercial cases),<br><br>
            ⦁ Use of any program on the {{ config('app.name') }} website for codification or reverse engineering of the
            software,<br><br>
            ⦁ Removal of copyright or other proprietary rights on the site,<br><br>
            ⦁ Sharing of website content and materials with third parties or using them on other websites,<br><br>
            If you violate any of these restrictions, this license is automatically terminated and may be terminated by
            {{ config('app.name') }} at any time.<br><br>
            You must destroy any electronic or printed downloaded materials in your possession after you have terminated
            your viewing of such materials or at the expiration of this license.<br><br>
            <strong>2.2. Prohibited Actions:</strong><br><br>
            ⦁ It is forbidden to use more than one account in {{ config('app.name') }}. You must immediately notify the website
            management of the accounts created with the error. If more than one account is used, the all accounts of
            user will be automatically banned by the website administration.<br><br>
            ⦁ The use of automatic boats and / or other unjustified means is strictly prohibited in {{ config('app.name') }}.<br><br>
            ⦁ As a precaution against fraud, the use of VPN or proxy software to hide your real identity is not
            permitted.<br><br>
            ⦁ It is not allowed to use scripts, extensions or other programs that change the content of the web page. So
            all sorts of ad-blockers are prohibited.<br><br>
            ⦁ The user is not allowed to perform suspicious / malicious actions. (unauthorized access, exploit errors or
            vulnerabilities, reduce service performance, DDoS attack, etc.)<br><br>
            If you perform any of the above prohibited actions, your account will be cancelled and/or banned. In such
            cases, if deemed necessary, law enforcement may be applied.<br><br>
            <strong>2.3 {{ config('app.name') }} and user rights</strong><br><br>
            ⦁ We reserve the right to change the offered prices at any time without prior notice. Please follow our
            website for up-to-date information.<br><br>
            ⦁ We reserve the right to change or remove any website features without prior notice.<br><br>
            ⦁ The user is responsible for the security of his or her account on our website.<br><br>
            ⦁ No responsibility is accepted if the balance is lost or damage to your account is caused by the user's
            self-infringed security breach (theft or hacked of his or her account, etc.).<br><br>
            ⦁ To begin using our website, users must verify their email address. Personal information and additional
            documents may be requested from the user if necessary. We reserve the right not to pay the user or suspend
            the account unless this verification process is performed.<br><br>
            ⦁ The use of our website is completely free. You are in no way asked for money or a substitute for
            money.<br><br>
            ⦁ The terms of use of cryptocurrencies may vary depending on your country and region. Therefore, all legal
            responsibility and savings of cryptocurrencies acquired from our site belong to the user.<br><br>
            ⦁ We use cookies to help you get the most out of our website and to improve the user advertising experience.
            Cookies must be activated in your browser in order to use our site without any problems.<br><br>
            ⦁ Our website is designed for recreational use. Therefore, all kinds of tax, legal responsibility is
            entirely up to the user.<br><br>
            ⦁ {{ config('app.name') }} uses 3rd party plugins to provide services such as shortlink, mining and offerwall. These
            services or the ads shown are not in our responsibility or control. {{ config('app.name') }} does not accept responsibility
            for any inconvenience or problems that may arise due to any of these. However, justifiable requests from
            users will be evaluated.<br><br>
            ⦁ Our website cannot be used as a wallet account. Your balances on our website are in the user's
            responsibility and the user is responsible for any problems that may occur.<br><br>
            ⦁ On our website, accounts that have not taken any action within 90 days may be suspended.<br><br>
            ⦁ The user investigates and agrees that even if there is a balance in his or her account at the end of 90
            days, he or she may be suspended and has no right to make any claims.<br><br>
            ⦁ If necessary, users can submit any questions and problems to us via the contact form or ticket system
            located on our website.The language you will use when submiting your problems or requests should be only in
            English. Messages other than English will not be answered by us.<br><br>
            ⦁ In order to get better service from our website, {{ config('app.name') }} is updated from time to time and we announce
            the interruptions caused by us through our social media (Facebook /Twitter) accounts.<br><br>
            ⦁ Only announcements made on our website and social media account (Facebook/Twitter) are valid. Please do
            not take into account announcements other than our own accounts, made by 3rd parties and other sites or
            social media accounts.<br><br>
            ⦁ The services we provide are only for users aged 18 and over. When you start using our website you
            acknowledge that you are 18 or older.<br><br>
            <strong>2.4. Account deletion and suspending</strong><br><br>
            ⦁ If the user requests, the account can be deleted.<br><br>
            ⦁ {{ config('app.name') }} may suspend, disable, freeze, or delete your account if {{ config('app.name') }} finds that you have violated
            any provision of this agreement or that your actions may damage {{ config('app.name') }}'s reputation.<br><br>
            ⦁ Account freezing can be done automatically by the anti fraud system. In this context, it is not possible
            to manually activate any account.<br><br>
            Accounts that have been disabled or deleted cannot be restored. Even if your account is deleted, some
            information will be retained by us. You can contact us via the contact form to find out which information
            will be stored on us.<br><br>
            <strong>3. Disclaimer</strong><br><br>
            ⦁ Contents on {{ config('app.name') }}’s website are provided as they are. {{ config('app.name') }} in no way assumes any responsibility
            for the content, including warranties, copyrights, restrictions, and commercial rights.<br><br>
            ⦁ In addition, {{ config('app.name') }} makes no statements and assumes no responsibility for the accuracy, possible
            consequences, or reliability of the use of any content contained on or linked to the website.<br><br>
            <strong>4. Limitations</strong><br><br>
            {{ config('app.name') }} suppliers shall not be liable for any damage, material loss, data loss, or interruptions caused by
            the use or non-use of the content on the {{ config('app.name') }} website.<br><br>
            Some courts dealing with disputed matters arising from disputes, do not allow partial warranties or
            liability for indirect or accidental damages. But these restrictions may not apply to you.<br><br>
            <strong>5. Accuracy of materials</strong><br><br>
            Content on {{ config('app.name') }}'s website may include technical, typographic, or photographic errors. {{ config('app.name') }} does
            not warrant that any material on the website is accurate, complete or up-to-date.<br><br>
            {{ config('app.name') }} has the right to make changes to the materials on the website at any time without notice. However,
            {{ config('app.name') }} does not accept responsibility for updating the content on the website.<br><br>
            <strong>6. Links</strong><br><br>
            {{ config('app.name') }} does not review the content of the websites it links to and is not responsible for such contents.
            The site on which the link is linked does not mean that it is approved by {{ config('app.name') }}. The user is responsible
            for the risks that may arise from the Linked Site.<br><br>
            <strong>7. Modifications</strong><br><br>
            {{ config('app.name') }} may revise the terms of service of the website at any time without notice. By using the {{ config('app.name') }}
            website, you agree to be bound by the terms of service applicable to the period in which these terms of
            service are used.<br><br>
            <strong>8. Governing Law</strong><br><br>
            These terms and conditions are governed by and interpreted in accordance with the laws of the Republic of
            Malta and you are subject to the jurisdiction of the Malta judiciary.
        </p><br><br>
    </div>
    <div class="container-fluid footer">
        <div class="container">
            <div class="row">
                <div class="col" id="slideRight">
                    <img src="{{ asset('img/logo.png') }}" height="40" width="auto" alt="Logo" class="logo">
                    <p class="comp-desc">We are one of the most reliable faucet websites all over the world. We are
                        providing our free services.</p>
                </div>
                <div class="col" id="slideUp">
                    <p class="title">SERVICES &amp; MORE</p>
                    <ul class="footer-menu">
                        <li><a href="{{ route('login') }}">Shortlinks</a></li>
                        <li><a href="{{ route('login') }}">Autofaucet</a></li>
                    </ul>
                </div>
                <div class="col" id="slideLeft">
                    <p class="title">Get social</p>
                    <div class="social-box">
                        <a href="https://twitter.com/timebitco_in" target="_blank" rel="nofollow noopener noreferrer">
                            <i class="fab fa-twitter twitter"></i>
                        </a>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col">
                    <p class="copyright">Copyright © 2021 - {{ config('app.name') }}</p>
                </div>
                <div class="col">
                    <p class="terms-conditions">
                        <a href="{{ route('terms') }}">Terms &amp; Conditions</a>
                    </p>
                </div>
            </div>
            <ul></ul>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"
        integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-Piv4xVNRyMGpqkS2by6br4gNJ7DXjqk09RmUpJ8jgGtD7zP9yug3goQfGII0yAns" crossorigin="anonymous">
    </script>
    <script src="https://js.hcaptcha.com/1/api.js" async defer></script>
</body>

</html>