<x-app-layout>
    <div>
        <div class="w-content">
            <div class="row page-stats-area">
                <div class="col item">
                    <div class="content-box">
                        <p class="title">Available Balance</p>
                        <p class="amount"><span id="availableBalance">{{ number_format($balance, 8, '.', '') }}</span>
                            {{ strtoupper($staking_plan->currency->short_name) }}</p>
                    </div>
                    <div class="icon-area green">
                        <i class="fas fa-coins icon"></i>
                    </div>
                </div>
                <div class="col item">
                    <div class="content-box">
                        <p class="title">Total staking</p>
                        <p class="amount"><span id="totalWithdrawn">0.00000000</span>
                            {{ strtoupper($staking_plan->currency->short_name) }}</p>
                    </div>
                    <div class="icon-area red">
                        <i class="fas fa-cube icon"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="banner d-block d-md-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!--banner-->
            </div>
        </div>
        <div class="banner d-none d-lg-block text-center" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!--banner-->
            </div>
        </div>
        <div class="m-area">
            <p class="title">{{ $staking_plan->name }}</p>
            <hr>
            <p class="desc">By filling the form below, you will be start to stake and earn daily earnings to your main
                balance.
                Your funds in stake will be added to your main balance when staking completed.</p>
            <div class="p-4 border rounded mt-4">
                <p class="px-4 text-center font-weight-bold h2" style="color:#a43af5;">{{$staking_plan->daily_earning*365}}%
                </p>
                <p class="text-center text-muted mb-4" style="font-size: 13px;">Annualized Percentage Yield</p>
                <div class="iconCoin mx-auto">
                    <img src="/img/BTC.png" width="40" height="40" alt="btc">
                </div>
                <h2 class="text-center font-weight-bold text-muted">{{$staking_plan->duration}} Days</h2>
            </div>
            <form name="form-withdraw" id="form-withdraw" action="{{ route('staking.store') }}" method="post">
                @csrf
                <div class="form-row form">
                    <div class="col">
                        <label for="amount">Amount</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="amount" name="amount" placeholder="0.00000000"
                                aria-describedby="maxwith-addon" required="">
                            <button class="btn btn-light" type="button" id="maxwith-addon">MAX</button>
                        </div>
                    </div>
                    <div class="col">
                        <label for="captcha-select">Captcha</label>
                        <select class="form-control captcha-select" id="captcha-select" name="captcha-select">
                            <option value="hcaptcha">hCaptcha</option>
                        </select>
                    </div>
                </div>
                <div class="form-row form">
                    <div class="col">
                        <div class="h-captcha" data-sitekey="{{$settings[1]->value}}" data-theme="light"></div>
                        <input type="hidden" name="plan_id" value="{{$staking_plan->id}}">
                        <button type="submit" id="withSub" class="btn btn-primary button float-left mt-25">Stake
                            {{ strtoupper($staking_plan->currency->short_name) }}</button>
                    </div>
                </div>
                <div class="clearfix"></div>
            </form>
        </div>
        <div class="banner d-block d-md-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!--banner-->
            </div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-lg-block text-center" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <x-footer></x-footer>
    </div>
    <script>
    $("#maxwith-addon").on("click", function() {
        $("#amount").val($("#availableBalance").text());
    });
    </script>
</x-app-layout>