<x-app-layout>
    <div class="">
        <div class="s-area">
            <p class="title-b">Referrals</p>
            <div class="clearfix"></div>
            <ul class="nav nav-tabs sub-area" id="referrals" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active show" id="overview-tab" data-toggle="tab" href="#overview" role="tab"
                        aria-controls="overview" aria-selected="true">Overview</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="referred-users-tab" data-toggle="tab" href="#referred-users" role="tab"
                        aria-controls="referred-users" aria-selected="false">Referred Users</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="banners-tab" data-toggle="tab" href="#banners" role="tab"
                        aria-controls="banners" aria-selected="false">Banners</a>
                </li>
            </ul>
        </div>
        <div class="banner d-block d-md-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!-- BANNER HERE -->
            </div>
        </div>
        <div class="banner d-none d-lg-block text-center" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!-- BANNER HERE -->
            </div>
        </div>
        <div class="tab-content ref-content" id="referralsContent">
            <div class="tab-pane fade active show" id="overview" role="tabpanel" aria-labelledby="overview-tab">
                <div class="row page-stats-area">
                    <div class="col item">
                        <div class="content-box">
                            <p class="title">Total Referrals</p>
                            <p class="amount">{{ $refs_count }}</p>
                        </div>
                        <div class="icon-area blue">
                            <i class="fas fa-chart-bar icon"></i>
                        </div>
                    </div>
                    <div class="col item">
                        <div class="content-box">
                            <p class="title">Current Rate</p>
                            <p class="amount">{{ $ref_earning->value }}%</p>
                        </div>
                        <div class="icon-area green">
                            <i class="fas fa-chart-pie icon"></i>
                        </div>
                    </div>
                </div>
                <div class="m-area">
                    <p class="title">Overview</p>
                    <hr>
                    <p class="desc">Get life time referral bonuses through every new user you suggest us! The bonus will
                        be added into your account, everytime they make a claim!</p>
                    <div class="link-area">
                        <div class="link" id="myInput">{{ url('/') }}/r/{{ Auth::user()->name }}</div>
                        <div class="w50" onclick="copyClipboard()">
                            <i class="fas fa-copy"></i>
                        </div>
                    </div>
                    <p class="desc">Share your referral link now with your friends to start to get your life time bonus.
                    </p>
                </div>
            </div>
            <div class="tab-pane fade" id="referred-users" role="tabpanel" aria-labelledby="referred-users-tab">
                <div class="m-area">
                    <p class="title">Referred Users</p>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th scope="col">Username</th>
                                    <th scope="col">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($referrals as $value)
                                <tr>
                                    <td>{{ $value->user->name }}</td>
                                    <td>{{ $value->created_at }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        {!! $referrals->links() !!}
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="banners" role="tabpanel" aria-labelledby="banners-tab"></div>
        </div>
        <div class="banner d-block d-md-none text-center m-auto">
            <div class=" d-inline-block text-center m-auto">
                <!-- BANNER HERE -->
            </div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-lg-block text-center">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <x-footer></x-footer>
    </div>

    <script>
    function copyClipboard() {
        /* Get the text field */
        var copyText = $("#myInput").text();

        /* Copy the text inside the text field */
        navigator.clipboard.writeText(copyText);

        /* Alert the copied text */
        new Notify({
            title: 'Copied!',
            text: "Referral link copied to clipboard",
            autoclose: true,
            autotimeout: 5000,
            status: 'success'
        })
    }
    </script>
</x-app-layout>