<x-app-layout>

    <div class="welcome">
        <div class="row">
            <div class="col">
                <div class="avatar">
                    <p>{{ substr(Auth::user()->name, 0, 1) }}</p>
                </div>
                <p class="username">Welcome back, {{ Auth::user()->name }}!</p>
            </div>
            <div class="col">
                @if(Auth::user()->level < 10)
                    <p class="text">Progress to Level {{Auth::user()->level+1}}</p>
                @endif
                <div class="wrap">
                    <i class="fas fa-gem bonus"></i>
                    <p class="title">{{$lvl_bonus}}%</p>
                    <p class="desc">Bonus</p>
                </div>
                <div class="wrap">
                    <i class="fas fa-level-up-alt level"></i>
                    <p class="title">{{Auth::user()->level}}.</p>
                    <p class="desc">Level</p>
                </div>
                <div class="clearfix"></div>
                <div class="progress">
                    <div class="progress-bar progress-bar-striped progress-bar-animated progress-color"
                        role="progressbar" aria-valuenow="{{$percent_lvl}}" aria-valuemin="0" aria-valuemax="100" style="width: {{$percent_lvl}}%">
                        {{$percent_lvl}}%
                    </div>
                </div>
                <p class="text"><b>{{$next_lvl}} Points</b> needed for next level!</p>
            </div>
        </div>
    </div>

    <div class="row balances mt-5">
        @foreach($coins as $key=>$value)
        <div class="col-md-3 px-0">
            <div class="p-2">
                <div class="card py-4 d-flex flex-row">
                    <div class="iconCoin">
                        <img src="{{ asset('img/'.$value->icon) }}" width="50" height="50"
                            alt="{{ $value->short_name }}">
                    </div>
                    <div class="details">
                        <p class="currencyText">{{ $value->name }}</p>
                        <p class="amountText">
                            @if($value->wallet)
                            {{ number_format($value->wallet->balance, 8, '.', '') }}
                            @else
                            0.00000000
                            @endif
                            <span class="text-uppercase">{{ $value->short_name }}</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>

    <x-footer></x-footer>

</x-app-layout>