<x-app-layout>
    <div class="">
        <meta http-equiv="refresh" content="600">
        <div class="w-content">
            <div class="row page-stats-area">
                <div class="col item">
                    <div class="content-box">
                        <p class="title">Available Energy</p>
                        <p class="amount">{{ Auth::user()->energy }} <span>Energy</span></p>
                    </div>
                    <div class="icon-area green">
                        <i class="fas fa-coins icon"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="banner d-block d-md-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-lg-block text-center" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="m-area">
            <p class="title">Auto Claim is running!</p>
            <div class="clearfix"></div>
            <p class="desc">The auto claiming is started. Please leave this window open for getting the payouts.</p>
            <hr>
            <div class="next-payout">
                <p class="600" id="600">Next payout in</p>
                <p class="mt-4 h4"><span class="time-left" id="minutes"></span>:<span class="time-left"
                        id="seconds"></span></p>
            </div>
            <hr>
            <div class="paid mid-600">
                <p class="message" id="message"></p>
            </div>
        </div>
        <div class="banner d-block d-md-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-lg-block text-center" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <x-footer></x-footer>
    </div>

    <script>
    var APP_URL = {!! json_encode(url('/')) !!}
    axios.get(`${APP_URL}/dashboard/claim/auto/api`)
        .then(function(response) {

            //console.log(response.data)

            if (response.data.message == "no_autoclaims") {
                //$("#message").html(`<i class="fas fa-check green"></i>0.00000188 ETC has been credited to your account.`);
                $("#message").html(
                    `<i class="fas fa-times red"></i>No data found, please return to the autoclaim section.`);
            } else if (response.data.message == "energy") {
                $("#message").html(`<i class="fas fa-times red"></i>Energy account insufficient.`);
            } else if (response.data.message == "time") {

                var wait = response.data.seconds - 1;

                const countDown = setInterval(() => {

                    if (typeof wait !== 'undefined') {
                        if (wait == 0) {
                            clearInterval(countDown);
                            location.reload();
                        }
                        let minutes = Math.floor(wait / 60);
                        let seconds = wait % 60;
                        $("#minutes").text(minutes);
                        $("#seconds").text(seconds);
                        wait -= 1;
                    }

                }, 1000);

            } else if (response.data.message == "ok") {

                $("#message").html(`<i class="fas fa-check green"></i> Rewards were credited to your account.`);

                var wait = response.data.seconds - 1;

                const countDown = setInterval(() => {

                    if (typeof wait !== 'undefined') {
                        if (wait == 0) {
                            clearInterval(countDown);
                            location.reload();
                        }
                        let minutes = Math.floor(wait / 60);
                        let seconds = wait % 60;
                        $("#minutes").text(minutes);
                        $("#seconds").text(seconds);
                        wait -= 1;
                    }

                }, 1000);

            }

        })
        .catch(function(error) {
            console.log(error);
        });
    </script>
</x-app-layout>