<x-app-layout>

    <div class="m-area">
        <p class="title">Edit User</p>
        <a href="{{ route('admin.users.index') }}" class="float-right">
        < Back
        </a>
        <hr>

        <form class="mt-5" action="{{ route('admin.users.update',$user->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="form-row form">
                <div class="col">
                    <label for="name">Username</label>
                    <input type="text" class="form-control" id="name" name="name" placeholder="Name" value="{{$user->name}}" required=""
                        autocomplete="off" readonly>
                </div>
                <div class="col">
                    <label for="email">Email</label>
                    <input type="text" class="form-control" id="email" name="email" placeholder="Email" value="{{$user->email}}" required=""
                        autocomplete="off" readonly>
                </div>
            </div>

            <div class="form-row form">
                <div class="col">
                    <label for="energy">Energy</label>
                    <input type="number" class="form-control" id="energy" name="energy" placeholder="Enter Energy" value="{{$user->energy}}"
                        required="" autocomplete="off">
                </div>
                <div class="col">
                    <label for="points">Level points</label>
                    <input type="number" class="form-control" id="points" name="points" placeholder="Enter level points" value="{{$user->points}}"
                        required="" autocomplete="off">
                </div>
                <div class="col">
                    <label for="is_admin">Is Admin</label>
                    <select name="is_admin" class="form-control" id="is_admin">
                        <option value="1" @if($user->is_admin == "1") selected @endif>True</option>
                        <option value="0" @if($user->is_admin == "0") selected @endif >False</option>
                    </select>
                </div>
                <div class="col">
                    <label for="blocked">Blocked</label>
                    <select name="blocked" class="form-control" id="blocked">
                        <option value="1" @if($user->blocked == "1") selected @endif>True</option>
                        <option value="0" @if($user->blocked == "0") selected @endif >False</option>
                    </select>
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12 text-center mt-5">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>

        </form>
    </div>

</x-app-layout>