<x-app-layout>
    <div class="">
        <div class="e-area">
            <p class="title mt-10">{{ $ticket->subject }}</p>
            <div class="float-right">
                <form action="{{ route('admin.tickets.update',$ticket->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    @if($ticket->status == 'open')
                        <input type="hidden" name="status" value="closed">
                        <button type="submit" class="btn btn-danger">Close ticket</button>
                    @else
                        <input type="hidden" name="status" value="open">
                        <button type="submit" class="btn btn-primary">Open</button>
                    @endif
                </form>
            </div>
            <div class="clearfix"></div>
        </div>
        <div class="t-area mb-5">
            <p class="title">
                Description
            </p>
            <p class="date">{{ $ticket->created_at }}</p>
            <hr>
            <p class="ticket-text">
                {{ $ticket->description }}
            </p>
            <div class="clearfix"></div>
        </div>
        <div class="e-area">
            <p class="title mt-10">Replies</p>
            <div class="button-area green" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true"
                aria-controls="collapseOne">
                <p class="view">Reply</p>
            </div>
            <div class="clearfix"></div>
        </div>
        <div class="m-area collapse" id="collapseOne">
            <form id="form-reply-ticket" name="form-reply-ticket" action="{{ route('admin.ticket.reply') }}"
                method="post">
                @csrf
                <div class="form-row form">
                    <div class="col">
                        <label for="message">Message</label>
                        <textarea class="form-control" id="message" name="message" placeholder="Message"
                            required=""></textarea>
                    </div>
                </div>
                <input type="hidden" name="ticket_id" value="{{ $ticket->id }}">
                <button type="submit" class="btn btn-primary button">Reply</button>
                <div class="clearfix"></div>
            </form>
        </div>
        @foreach($ticketanswer as $reply)
        @if($reply->messageby == 'admin')
        <div class="t-area blue">
            @else
            <div class="t-area">
                @endif
                <p class="title">
                    @if($reply->messageby == 'admin')
                    <i class="fas fa-life-ring"></i>
                    Support
                    @else
                    <i class="fas fa-user"></i>
                    {{ $reply->ticket->user->name }}
                    @endif
                </p>
                <p class="date">{{ $reply->created_at }}</p>
                <hr>
                <p class="ticket-text">
                    {{ $reply->message }}
                </p>
                <div class="clearfix"></div>
            </div>
            @endforeach
        </div>
</x-app-layout>