<x-app-layout>

    <div class="m-area">
        <p class="title">Edit Staking Plan</p>
        <a href="{{ route('admin.staking.index') }}" class="float-right">
        < Back
        </a>
        <hr>

        <form class="mt-5" action="{{ route('admin.staking.update', $staking->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="form-row form">
                <div class="col">
                    <label for="name">Name</label>
                    <input type="text" class="form-control" id="name" name="name" placeholder="Name" required="" value="{{$staking->name}}"
                        autocomplete="off">
                </div>
                <div class="col">
                    <label for="min_deposit">Min Deposit</label>
                    <input type="text" class="form-control" id="min_deposit" name="min_deposit" placeholder="Min. Deposit" required="" value="{{$staking->min_deposit}}"
                        autocomplete="off">
                </div>
                <div class="col">
                    <label for="max_deposit">Max Deposit</label>
                    <input type="text" class="form-control" id="max_deposit" name="max_deposit" placeholder="Max. Deposit" required="" value="{{$staking->max_deposit}}"
                        autocomplete="off">
                </div>
            </div>

            <div class="form-row form">
                <div class="col">
                    <label for="status">Plan Active</label>
                    <select name="status" class="form-control" id="status">
                        <option value="1" @if($staking->status == "1") selected @endif>True</option>
                        <option value="0" @if($staking->status == "0") selected @endif>False</option>
                    </select>
                </div>
                <div class="col">
                    <label for="daily_earning">Daily earning (%)</label>
                    <input type="text" class="form-control" id="daily_earning" name="daily_earning" placeholder="0.05" value="{{$staking->daily_earning}}"
                        required="" autocomplete="off">
                </div>
                <div class="col">
                    <label for="duration">Duration (days)</label>
                    <input type="text" class="form-control" id="duration" name="duration" placeholder="40" value="{{$staking->duration}}"
                        required="" autocomplete="off">
                </div>
                <div class="col">
                    <label for="coin_id">Currency</label>
                    <select name="coin_id" class="form-control" id="coin_id">
                        @foreach ($coins as $key => $value)
                            <option value="{{$value->id}}" @if($staking->coin_id == $value->id) selected @endif>{{$value->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12 text-center mt-5">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>

        </form>
    </div>

</x-app-layout>