<x-app-layout>
    <div class="transactions">
        <p class="title">Shortlinks</p>
        <a href="{{ route('admin.shortlinks.create') }}">
            <div class="button green">
                <p class="view">Add New Shortlink</p>
            </div>
        </a>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col">Name</th>
                        <th scope="col">URL</th>
                        <th scope="col">Energy</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $key => $value)
                    <tr>
                        <th scope="row">#{{ ++$i }}</th>
                        <td>{{ $value->name }}</td>
                        <td>{{ $value->url }}</td>
                        <td>{{ $value->energy }}</td>
                        <td>
                            <form action="{{ route('admin.shortlinks.destroy',$value->id) }}" method="POST">
                                <a class="btn btn-primary" href="{{ route('admin.shortlinks.edit',$value->id) }}">Edit</a>
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $data->links() !!}
        </div>

    </div>
</x-app-layout>