<x-app-layout>
    <div class="transactions">
        <p class="title">Proxy/VPN Detection</p>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col">User</th>
                        <th scope="col">IP</th>
                        <th scope="col">ASN</th>
                        <th scope="col">Provider</th>
                        <th scope="col">Country</th>
                        <th scope="col">Proxy</th>
                        <th scope="col">Type</th>
                        <th scope="col">Risk</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $key => $value)
                    <tr>
                        <th scope="row">#{{ ++$i }}</th>
                        <td>{{ $value->user->name }}</td>
                        <td>{{ $value->ip }}</td>
                        <td>{{ $value->asn }}</td>
                        <td>{{ $value->provider }}</td>
                        <td>{{ $value->country }}</td>
                        <td>{{ $value->proxy }}</td>
                        <td>{{ $value->type }}</td>
                        <td>{{ $value->risk }}</td>
                        <td>
                            <a class="btn btn-primary" href="{{ route('admin.users.edit',$value->user_id) }}">Show/Ban User</a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $data->links() !!}
        </div>

    </div>
</x-app-layout>