<x-app-layout>
    <div class="transactions">
        <p class="title">Deposits</p>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col">User</th>
                        <th scope="col">Amount</th>
                        <th scope="col">Currency</th>
                        <th scope="col">Date</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $key => $value)
                    <tr>
                        <th scope="row">#{{ ++$i }}</th>
                        <td>{{ $value->user->name }}</td>
                        <td>{{ number_format($value->amount, 8, '.', '') }} <span class="text-uppercase">{{ $value->currency->short_name }}</span></td>
                        <td>{{ $value->currency->name }}</td>
                        <td>{{ $value->updated_at }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $data->links() !!}
        </div>

    </div>
</x-app-layout>