<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShortlinksHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shortlinks_histories', function (Blueprint $table) {
            $table->id();
            $table->integer('energy')->default(0);
            $table->foreignId('shortlink_id')->constrained();
            $table->foreignId('user_id')->constrained();
            $table->enum('status', ['pending', 'completed', 'expired'])->default('pending');
            $table->string('verify_code')->nullable(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shortlinks_histories');
    }
}
