<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->integer('energy')->default(0);
            $table->integer('points')->default(0);
            $table->integer('level')->default(1);
            $table->string('faucetpay_acc')->nullable();
            $table->string('expresscrypto_acc')->nullable();
            $table->dateTime('last_autoclaim')->nullable();
            $table->dateTime('last_claim')->nullable();
            $table->boolean('is_admin')->default(0);
            $table->boolean('blocked')->default(0);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
