<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Coin;

class StakingPlan extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'min_deposit', 'max_deposit', 'daily_earning', 'duration', 'status', 'coin_id'
    ];

    public function currency()
    {
        return $this->belongsTo(Coin::class, 'coin_id');
    }

}
