<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\StakingPlan;

class StakingHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'amount', 'days', 'status', 'staking_plans_id', 'user_id', 'earnings'
    ];

    public function plan()
    {
        return $this->belongsTo(StakingPlan::class, 'staking_plans_id');
    }

}
