<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Referral;
use App\Models\User;

class Referral extends Model
{
    use HasFactory;

    protected $fillable = [
        'refers_to', 'referred_by'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'refers_to');
    }

    function referredTo() {
        return $this->hasMany(Referral::class, 'refers_to');
    }   
}
