<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\Coin;

class DepositHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'amount', 'status', 'coin_id', 'user_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function currency()
    {
        return $this->belongsTo(Coin::class, 'coin_id');
    }

}
