<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Ticket;
use App\Models\TicketAnswer;

class AdminTicketsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Ticket::latest()->paginate(20);
    
        return view('admin.tickets.index',compact('data'))
            ->with('i', (request()->input('page', 1) - 1) * 20);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Ticket $ticket)
    {
        $ticketanswer = Ticket::find($ticket->id)->replies;
        return view('admin.tickets.show',compact('ticket', 'ticketanswer'));
    }

    /**
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function adminReply(Request $request)
    {
        //
        $request->validate([
            'ticket_id' => 'required',
            'message' => 'required',
        ]);

        $requestData = $request->all();
        $requestData['messageby'] = 'admin';
        TicketAnswer::create($requestData);

        $ticket = Ticket::find($requestData['ticket_id']);
        $ticket->update(['last_answer' => 'admin']);
    
        return redirect()->route('admin.tickets.index')
                        ->with('success','Answer sent successfully.');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Ticket $ticket)
    {
        $request->validate([
            'status' => 'required',
        ]);
    
        $ticket->update($request->all());
    
        return redirect()->route('admin.tickets.index')
                        ->with('success','Ticket updated successfully');
    }

}
