<?php

namespace App\Http\Controllers;

use App\Models\Ticket;
use App\Models\TicketAnswer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TicketAnswerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $request->validate([
            'ticket_id' => 'required',
            'message' => 'required',
        ]);

        $requestData = $request->all();
        $requestData['messageby'] = 'user';
        TicketAnswer::create($requestData);

        $ticket = Ticket::find($requestData['ticket_id']);
        $ticket->update(['last_answer' => 'user']);
    
        return redirect()->route('tickets.index')
                        ->with('success','Answer sent successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
