<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Coin;
use App\Models\Settings;
use App\Models\DepositHistory;
use Illuminate\Support\Facades\Auth;

class DepositController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $coins = Coin::all();
        return view('deposit.index', compact('coins'));
    }

    /**
     * history the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function history()
    {
        //
        $data = DepositHistory::latest()->where('user_id', Auth::user()->id)->paginate(20);
        return view('deposit.history', compact('data'))
                            ->with('i', (request()->input('page', 1) - 1) * 20);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $request->validate([
            'amount' => 'required',
            'coin_id' => 'required',
        ]);

        $requestData = $request->all();

        if($requestData['amount'] > 0){

            $id = DepositHistory::create([
                'amount' => $requestData['amount'],
                'status' => 'pending',
                'coin_id' => $requestData['coin_id'],
                'user_id' => Auth::user()->id,
            ])->id;
            return redirect()->route('deposit.show', $id);

        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $data = DepositHistory::where('id', $id)->where('user_id', Auth::user()->id)->first();
        $fp_username = Settings::where('name', 'fp_username')->first();
        if($data){
            return view('deposit.faucetpay', compact('data', 'fp_username'));
        }else{
            return redirect()->route('deposit.index')
                        ->with('error','Not found.');
        }
    
    }

    /**
     * IPN a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function ipn(Request $request)
    {
        //

        $requestData = $request->all();

        $token = $requestData['token'];

        $payment_info = file_get_contents("https://faucetpay.io/merchant/get-payment/" . $token);
        $payment_info = json_decode($payment_info, true);
        $token_status = $payment_info['valid'];

        $merchant_username = $payment_info['merchant_username'];
        $amount1 = $payment_info['amount1'];
        $currency1 = $payment_info['currency1'];
        $custom = $payment_info['custom'];

        $fp_username = Settings::where('name', 'fp_username')->first();
        $my_username = $fp_username->value;

        if ($my_username == $merchant_username && $token_status == true) {

            $deposit = DepositHistory::where('id', $custom)->first();
            if ($deposit) {
                $wallet = Balance::where('user_id', $deposit->user_id)->where('coin_id', $deposit->coin_id)->first();
                if ($wallet) {
                    $wallet->balance = $wallet->balance + $amount1;
                    $wallet->save();
                    $deposit->status = 'completed';
                    $deposit->save();
                    echo 'ok';
                } else {
                    echo 'error';
                }
            } else {
                echo 'error';
            }

        } else {

            echo 'Someone is trying to hack you.';

        }

    }
}
