<?php

namespace App\Http\Controllers;

use App\Models\Settings;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DailyBonusController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $bonus = Settings::where('name', 'daily_bonus')->first();
        $user = User::where('id', Auth::user()->id)->first();

        $last_bonus = Auth::user()->last_bonus;
        if ($last_bonus != null) {
            $last_bonus = strtotime($last_bonus);
        } else {
            $last_bonus = 0;
        }

        $date = Carbon::parse($last_bonus)
            ->addMinutes(1440);

        $nowtime = Carbon::now();

        if($nowtime > $date){

            $diff = 0;

            return view('bonus', ['diff' => $diff]);

        }else{
            $diff = $date->diffInMinutes($nowtime); 
            return view('bonus', ['diff' => $diff]);
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $bonus = Settings::where('name', 'daily_bonus')->first();
        $user = User::where('id', Auth::user()->id)->first();

        $last_bonus = Auth::user()->last_bonus;
        if ($last_bonus != null) {
            $last_bonus = strtotime($last_bonus);
        } else {
            $last_bonus = 0;
        }

        $date = Carbon::parse($last_bonus)
            ->addMinutes(1440);

        $nowtime = Carbon::now();

        if($nowtime > $date){
            $user->energy = $user->energy + $bonus->value;
            $user->last_bonus = Carbon::now();
            $user->save();

            return redirect()->back()
                ->with('success', 'Daily bonus claimed!');

        }else{
            $diff = $date->diffInMinutes($nowtime); 
            return redirect()->back()
                        ->with('error', 'Please wait '.$diff.' minutes');
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
