<?php

if (!function_exists('verifyHcaptcha')) {
    function verifyHcaptcha($secret_key, $user_key)
    {
        $data = array(
            'secret' => $secret_key,
            'response' => $user_key
        );
        $verify = curl_init();
        curl_setopt($verify, CURLOPT_URL, "https://hcaptcha.com/siteverify");
        curl_setopt($verify, CURLOPT_POST, true);
        curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($verify);
        // var_dump($response);
        $responseData = json_decode($response);
        if($responseData->success) {
            return 1;
        } 
        else {
            return 0;
        }
    }
}

if (!function_exists('faucetpayBalance')) {
    function faucetpayBalance($api_key, $currency)
    {

        $data = array(
            'api_key' => $api_key,
            'currency' => $currency
        );
        $endpoint = "https://faucetpay.io/api/v1/balance";
        $verify = curl_init();
        curl_setopt($verify, CURLOPT_URL, $endpoint);
        curl_setopt($verify, CURLOPT_POST, true);
        curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($verify);
        //var_dump($response);
        $responseData = json_decode($response);
        //var_dump($responseData->status);
        if($responseData->status == "200") {
            return $responseData->balance;
        } 
        else {
            return 0;
        }
    }
}

if (!function_exists('faucetpaySend')) {
    function faucetpaySend($api_key, $currency, $amount, $to, $referral=false)
    {

        $data = array(
            'api_key' => $api_key,
            'currency' => $currency,
            'amount' => $amount,
            'to' => $to,
            'referral' => $referral
        );
        $endpoint = "https://faucetpay.io/api/v1/send";
        $verify = curl_init();
        curl_setopt($verify, CURLOPT_URL, $endpoint);
        curl_setopt($verify, CURLOPT_POST, true);
        curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($verify);
        //var_dump($response);
        $responseData = json_decode($response);
        //var_dump($responseData->status);
        if($responseData->status == "200") {
            return 1;
        } 
        else {
            return 0;
        }
    }
}
